VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.ocx"
Begin VB.UserControl Cap_OfferTemp 
   ClientHeight    =   12750
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   17010
   ScaleHeight     =   12750
   ScaleWidth      =   17010
   Begin VB.Frame fra_MainItem 
      Height          =   5910
      Left            =   -105
      TabIndex        =   0
      Tag             =   "fra_MainItem"
      Top             =   1335
      Width           =   17070
      Begin VB.Frame fra_GridFilter 
         Height          =   975
         Left            =   4335
         TabIndex        =   16
         Tag             =   "fra_GridFilter"
         Top             =   1125
         Width           =   12570
         Begin VB.CommandButton btn_ExportCADPDF 
            Caption         =   "#Export CAD/PDF"
            Height          =   645
            Left            =   11100
            TabIndex        =   26
            Tag             =   "btn_ExportCADPDF"
            Top             =   225
            Width           =   1080
         End
         Begin VB.CommandButton btn_ShowPDF 
            Caption         =   "#Show PDF"
            Height          =   645
            Left            =   10125
            TabIndex        =   27
            Tag             =   "btn_ShowPDF"
            Top             =   225
            Width           =   990
         End
         Begin VB.CommandButton btn_XmlPMaster 
            Caption         =   "#Export XML PMaster"
            Height          =   645
            Left            =   9060
            TabIndex        =   19
            Tag             =   "btn_XmlPMaster"
            Top             =   225
            Width           =   1080
         End
         Begin VB.CommandButton cmd_RecalcCost 
            Caption         =   "#Recalculate cost"
            Height          =   645
            Left            =   7935
            TabIndex        =   20
            Tag             =   "cmd_RecalcCost"
            Top             =   225
            Width           =   1140
         End
         Begin VB.CommandButton btn_PosListClearBOMBOR 
            Caption         =   "#Clear BOM && BOR"
            Height          =   645
            Left            =   6855
            TabIndex        =   21
            Tag             =   "cmd_PosListClearBOMBOR"
            Top             =   225
            Width           =   1095
         End
         Begin VB.CommandButton btn_PosListCalcBOMBOR 
            Caption         =   "#Generate BOM && BOR"
            Height          =   645
            Left            =   5775
            TabIndex        =   22
            Tag             =   "cmd_PosListCalcBOMBOR"
            Top             =   225
            Width           =   1095
         End
         Begin VB.CommandButton btn_PosListEdit 
            Caption         =   "#Edit attributes"
            Height          =   645
            Left            =   4920
            TabIndex        =   25
            Tag             =   "cmd_PosListEdit"
            Top             =   225
            Width           =   870
         End
         Begin VB.TextBox txt_Textbox 
            Height          =   345
            Index           =   1
            Left            =   3525
            TabIndex        =   23
            Tag             =   "PRD_Code"
            Top             =   390
            Width           =   1305
         End
         Begin VB.TextBox txt_Textbox 
            Height          =   345
            Index           =   0
            Left            =   1125
            TabIndex        =   17
            Tag             =   "PRD_CodeAMC"
            Top             =   390
            Width           =   1305
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#SAP Code"
            Height          =   210
            Index           =   0
            Left            =   2520
            TabIndex        =   24
            Tag             =   "lbl_SAP_Code"
            Top             =   435
            Width           =   885
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#AMC Code"
            Height          =   210
            Index           =   2
            Left            =   120
            TabIndex        =   18
            Tag             =   "lbl_AMC_Code"
            Top             =   450
            Width           =   885
         End
      End
      Begin VB.CommandButton cmd_TVReLoad 
         Height          =   855
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   4
         Top             =   3210
         Width           =   975
      End
      Begin VB.Frame fra_MainFilter 
         Height          =   2505
         Left            =   75
         TabIndex        =   1
         Tag             =   "fra_MainFilter"
         Top             =   135
         Width           =   4170
         Begin VB.Frame fra_FilterCategory 
            Height          =   540
            Left            =   45
            TabIndex        =   13
            Tag             =   "fra_FilterCategory"
            Top             =   120
            Width           =   4005
            Begin VB.OptionButton opt_Category 
               Caption         =   "#SKU"
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   15
               Tag             =   "opt_CategorySKU"
               Top             =   225
               Value           =   -1  'True
               Width           =   1920
            End
            Begin VB.OptionButton opt_Category 
               Caption         =   "#Custom"
               Height          =   195
               Index           =   1
               Left            =   2115
               TabIndex        =   14
               Tag             =   "opt_CategoryCustom"
               Top             =   225
               Width           =   1620
            End
         End
         Begin VB.OptionButton opt_date 
            Caption         =   "#All"
            Height          =   255
            Index           =   0
            Left            =   75
            TabIndex        =   9
            Tag             =   "dateAll"
            Top             =   1440
            Value           =   -1  'True
            Width           =   1750
         End
         Begin VB.OptionButton opt_date 
            Caption         =   "#Between"
            Height          =   255
            Index           =   1
            Left            =   1815
            TabIndex        =   8
            Tag             =   "dateBetween"
            Top             =   1440
            Width           =   2200
         End
         Begin Project1.ArmCombobox cbo_date 
            Height          =   345
            Left            =   75
            TabIndex        =   7
            Tag             =   "date_type"
            Top             =   2100
            Visible         =   0   'False
            Width           =   3975
            _ExtentX        =   7011
            _ExtentY        =   609
         End
         Begin Project1.A_calocx cal12 
            Height          =   330
            Left            =   2235
            TabIndex        =   10
            Tag             =   "date_till"
            Top             =   1755
            Visible         =   0   'False
            Width           =   1830
            _ExtentX        =   3228
            _ExtentY        =   582
         End
         Begin Project1.A_calocx cal11 
            Height          =   330
            Left            =   75
            TabIndex        =   11
            Tag             =   "date_since"
            Top             =   1755
            Visible         =   0   'False
            Width           =   1830
            _ExtentX        =   3228
            _ExtentY        =   582
         End
         Begin VB.Label lbl_DateRange 
            Caption         =   "#Date range"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   75
            TabIndex        =   12
            Tag             =   "lbl_DateRange"
            Top             =   1140
            Width           =   1215
         End
      End
      Begin Project1.ArmGrid grd_Main 
         Height          =   3375
         Left            =   4380
         TabIndex        =   2
         Tag             =   "grd_Offer"
         Top             =   2100
         Width           =   2655
         _ExtentX        =   4683
         _ExtentY        =   5953
      End
      Begin Project1.ToolbarControl tlb_Main 
         Height          =   690
         Left            =   4395
         TabIndex        =   3
         Tag             =   "2903"
         Top             =   345
         Width           =   2655
         _ExtentX        =   4683
         _ExtentY        =   1217
      End
      Begin Project1.ArmCombobox cbo_View 
         Height          =   345
         Left            =   75
         TabIndex        =   5
         Tag             =   "cbo_View"
         Top             =   2775
         Width           =   4035
         _ExtentX        =   7117
         _ExtentY        =   609
      End
      Begin Project1.ArmTreeView tvw_Main 
         Height          =   1935
         Left            =   75
         TabIndex        =   6
         Tag             =   "tvw_Main"
         Top             =   3165
         Width           =   3990
         _ExtentX        =   7038
         _ExtentY        =   3413
      End
   End
   Begin MSComctlLib.ImageList iml_Icons 
      Left            =   120
      Top             =   120
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483633
      MaskColor       =   16711935
      _Version        =   393216
   End
End
Attribute VB_Name = "Cap_OfferTemp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Const CL_COLOR_ENABLED  As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_Expired  As Long = 10066414          ' # EE9999
Private Const CL_COLOR_Requested    As Long = 10066414      ' # EE9999
Private Const CL_COLOR_Delivered    As Long = 10088089      ' # 99EE99
Private Const FRM_SPACE_VER = 120
Private Const FRM_SPACE_HOR = 100
Private Const ICON_RELOAD = 115

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const SCREEN_NAME As String = "Cap_OfferTemp"

'******** Curseur de connexion
#If ENV = LIVE Then
Private mo_Sys As Object
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Sys As ARMSYSCOMLib.ArmSYS
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As Scripting.FileSystemObject
#End If


Private mo_Tools As DPC_Tools

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private ms_UID As String
Private ml_U_Code As Long
Private ms_LoginName As String
Private ms_Language_Code As String
Private mb_InternalInit As Boolean
Private ms_DecimalSeparator As String
Private ms_ThousandSeparator As String
Private mc_ScreenLabels As Long
Private mo_WshNetwork As Object
Private ms_ComputerName As String
Private mv_TreeviewInfo As Variant
Private ml_iConcurrency As Long
Private mt_CstValues As type_CstValues
Private ms_Caption As String
Private mb_Initialized As Boolean

Public Event quit()

Public Property Set ArmDb(ByRef ao_Db As Object)
On Error GoTo ErrorHandler

  Set mo_Db = ao_Db
  Exit Property
ErrorHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Get ArmDb() As Object
On Error GoTo ErrorHandler

  Set ArmDb = mo_Db
  Exit Property
ErrorHandler:
  Call ErrorHandler("ArmDb.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Let Language_Code(ByVal as_Language_Code As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property

Public Property Get Language_Code() As String
On Error GoTo ErrHandler
  
  Language_Code = ms_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Get")
End Property

Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrorHandler

  ml_U_Code = al_U_Code
  Exit Property
ErrorHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_Value As String)
On Error GoTo ErrorHandler

  ms_LoginName = as_Value
  Exit Property
ErrorHandler:
  Call ErrorHandler("LoginName.Let")
End Property

Public Property Let Caption(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  ms_Caption = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Caption.Let")
End Property

Public Property Get Caption() As String
On Error GoTo ErrHandler
    
  Caption = ms_Caption
  Exit Property
ErrHandler:
  Call ErrorHandler("Caption.Get")
End Property

Public Property Let Name(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  UserControl.Extender.Name = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Name.Let")
End Property

Public Property Get Name() As String
On Error GoTo ErrHandler
    
  Name = UserControl.Extender.Name
  Exit Property
ErrHandler:
  Call ErrorHandler("Name.Get")
End Property

Public Property Let Tag(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  UserControl.Tag = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Tag.Let")
End Property

Public Property Get Tag() As String
On Error GoTo ErrHandler
    
  Tag = UserControl.Tag
  Exit Property
ErrHandler:
  Call ErrorHandler("Tag.Get")
End Property

Public Property Let Visible(ByVal aVisible As Boolean)
On Error GoTo ErrHandler
    
  UserControl.Extender.Visible = aVisible
  Exit Property
ErrHandler:
  Call ErrorHandler("Visible.Let")
End Property

Public Property Get Visible() As Boolean
On Error GoTo ErrHandler
    
  Visible = UserControl.Extender.Visible
  Exit Property
ErrHandler:
  Call ErrorHandler("Visible.Get")
End Property

Public Property Let Top(ByVal aTop As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Top = aTop
  Exit Property
ErrHandler:
  Call ErrorHandler("Top.Let")
End Property

Public Property Get Top() As Single
On Error GoTo ErrHandler
    
  Top = UserControl.Extender.Top
  Exit Property
ErrHandler:
  Call ErrorHandler("Top.Get")
End Property

Public Property Let Height(ByVal aHeight As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Height = aHeight
  Exit Property
ErrHandler:
  Call ErrorHandler("Height.Let")
End Property

Public Property Get Height() As Single
On Error GoTo ErrHandler
    
  Height = UserControl.Extender.Height
  Exit Property
ErrHandler:
  Call ErrorHandler("Height.Get")
End Property

Public Property Let Left(ByVal aLeft As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Left = aLeft
  Exit Property
ErrHandler:
  Call ErrorHandler("Left.Let")
End Property

Public Property Get Left() As Single
On Error GoTo ErrHandler
    
  Left = UserControl.Extender.Left
  Exit Property
ErrHandler:
  Call ErrorHandler("Left.Get")
End Property

Public Property Let Width(ByVal aWidth As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Width = aWidth
  Exit Property
ErrHandler:
  Call ErrorHandler(".Let")
End Property

Public Property Get Width() As Single
On Error GoTo ErrHandler
    
  Width = UserControl.Extender.Width
  Exit Property
ErrHandler:
  Call ErrorHandler("Width.Get")
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
On Error GoTo ErrHandler
  
  Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
  Exit Sub
ErrHandler:
  Call ErrorHandler("Move")
End Sub

Public Property Let Enabled(ByVal ab_Value As Boolean)
On Error GoTo ErrHandler

  UserControl.Enabled = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Enabled.Let")
End Property

Public Property Get Enabled() As Boolean
 On Error GoTo ErrHandler

  Enabled = UserControl.Enabled
  Exit Property
ErrHandler:
  Call ErrorHandler("Enabled.Get")
End Property

Public Sub Zorder()
On Error GoTo ErrHandler

  Call UserControl.Extender.Zorder
  Exit Sub
ErrHandler:
  Call ErrorHandler("Zorder")
End Sub

Public Sub Refresh()
On Error GoTo ErrHandler

  Call UserControl.Refresh
  Exit Sub
ErrHandler:
  Call ErrorHandler("Refresh")
End Sub

Public Property Get hwnd() As Long
On Error GoTo ErrHandler
  
  hwnd = UserControl.hwnd
  Exit Property
ErrHandler:
  Call ErrorHandler("hwnd.Get")
End Property

Public Property Get Initialized() As Boolean
On Error GoTo ErrHandler
    
  Initialized = mb_Initialized
  Exit Property
ErrHandler:
  Call ErrorHandler("Initialized.Get")
End Property

Private Property Get CAT_Id() As eDPCCategory
On Error GoTo ErrHandler

    If opt_Category(0).Value Then
      CAT_Id = eDPCCategory.cgMetalPanelSKU
    ElseIf opt_Category(1).Value Then
      CAT_Id = eDPCCategory.cgMetalCustomPanelTemplate
    Else
      CAT_Id = eDPCCategory.cgNone
    End If
  Exit Property
ErrHandler:
  Call ErrorHandler("CAT_Id.Get")
End Property
' Initialization of the component
Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim la_Columns() As Variant

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  'Set mo_Tools = New DPC_Tools
  'Set mo_Tools.ArmDb = mo_Db
  'Call mo_Tools.Load_A_COM
  
  Call mo_Tools.Load_A_ComControls(UserControl.Controls, mo_Db, ms_Language_Code)
    
  ms_ThousandSeparator = mo_Tools.GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND)
  ms_DecimalSeparator = Format(0, ".")
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  
#If ENV = LIVE Then
  Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
#Else
  Set mo_Sys = New ARMSYSCOMLib.ArmSYS
#End If
  
  Set mo_WshNetwork = CreateObject("WScript.Network")
  ms_ComputerName = mo_WshNetwork.ComputerName
  
  mb_InternalInit = True
  
  Call iml_Icons.ListImages.Clear
  Call iml_Icons.ListImages.Add(, , LoadResPicture("ERRORTYPE1", vbResBitmap))
  Call iml_Icons.ListImages.Add(, , LoadResPicture("ERRORTYPE2", vbResBitmap))
  Call iml_Icons.ListImages.Add(, , LoadResPicture("ERRORTYPE3", vbResBitmap))
  Call iml_Icons.ListImages.Add(, , LoadResPicture("LEVEL1", vbResBitmap))
  Call iml_Icons.ListImages.Add(, , LoadResPicture("LEVEL2", vbResBitmap))
  Call iml_Icons.ListImages.Add(, , LoadResPicture("LEVEL3", vbResBitmap))
  
  Set cmd_TVReLoad.Picture = mo_Tools.LoadIconFromA_Icons(ICON_RELOAD)
  cal11.opening_toward_top = 1
  cal12.opening_toward_top = 1
  Call SetTreeDelayedMode(False)
  Call mo_Tools.LoadComboView(mo_Db, cbo_View, SCREEN_NAME, ms_Language_Code)
  If Not cbo_View.SelectedItem Is Nothing Then
    mv_TreeviewInfo = mo_Tools.LoadTreeViewInfo(mo_Db, SCREEN_NAME, cbo_View.SelectedItem.Key)
    Call LoadTreeView(tvw_Main, mv_TreeviewInfo)
    Call LoadGrid(True)
  End If
   
  ReDim la_Columns(21)
  la_Columns(0) = "PRD_Id" & CH_LDELIMIT & "0" & CH_LDELIMIT & "1" & CH_LDELIMIT & "PRD_Id" & CH_LDELIMIT & ""
  la_Columns(1) = "Selected" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Selected" & CH_LDELIMIT & "#Sel" & CH_LDELIMIT & "BITMAP"
  la_Columns(2) = "STA_BOMBMP" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STA_BOMBMP" & CH_LDELIMIT & "#BOM" & CH_LDELIMIT & "BITMAP"
  la_Columns(3) = "STA_BORBMP" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STA_BORBMP" & CH_LDELIMIT & "#BOR" & CH_LDELIMIT & "BITMAP"
  la_Columns(4) = "PRD_Code" & CH_LDELIMIT & "700" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PRD_Code" & CH_LDELIMIT & "#PRD Code"
  la_Columns(5) = "BI_SAP_Code" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "0" & CH_LDELIMIT & "BI_SAP_Code" & CH_LDELIMIT & "#SAP Code"
  la_Columns(6) = "PRD_Name" & CH_LDELIMIT & "3000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PRD_Name" & CH_LDELIMIT & "#Name"
  la_Columns(7) = "RPL_ModA" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "RPL_ModA" & CH_LDELIMIT & "#Module length"
  la_Columns(8) = "RPL_ModB" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "RPL_ModB" & CH_LDELIMIT & "#Module width"
  la_Columns(9) = "RPL_PanA" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "RPL_PanA" & CH_LDELIMIT & "#Panel length"
  la_Columns(10) = "RPL_PanB" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "RPL_PanB" & CH_LDELIMIT & "#Panel width"
  la_Columns(11) = "PRF_Name" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PRF_Name" & CH_LDELIMIT & "#Perforation"
  la_Columns(12) = "IMG_Id" & CH_LDELIMIT & "0" & CH_LDELIMIT & "0" & CH_LDELIMIT & "IMG_Id" & CH_LDELIMIT & ""
  la_Columns(13) = "INL_Name1" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "INL_Name1" & CH_LDELIMIT & "#Fleece"
  la_Columns(14) = "INL_Name2" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "INL_Name2" & CH_LDELIMIT & "#Inlay"
  la_Columns(15) = "INL_Name3" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "INL_Name3" & CH_LDELIMIT & "#Acoustic pad"
  la_Columns(16) = "PCC_CostPCS" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PCC_CostPCS" & CH_LDELIMIT & "#ICTP PCS" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(17) = "PCC_CostM2" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PCC_CostM2" & CH_LDELIMIT & "#ICTP M2" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(18) = "Z_Creation" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_Creation" & CH_LDELIMIT & "#Creation Date"
  la_Columns(19) = "Z_CreatorDesc" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_CreatorDesc" & CH_LDELIMIT & "#Creation User"
  la_Columns(20) = "Z_Last_Upd" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_Last_Upd" & CH_LDELIMIT & "#Last upd., date"
  la_Columns(21) = "Z_Last_Upd_UserDesc" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_Last_Upd_UserDesc" & CH_LDELIMIT & "#Last upd. user"
  
  Call grd_Main.SetColumns(la_Columns)

  'Screen csts
  Call mo_Tools.LoadToolbars(mo_Db, UserControl.Controls, SCREEN_NAME)
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, UserControl.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(UserControl.Controls, gl_CodePage)
  
  mb_InternalInit = False
  mb_Initialized = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_Com")
End Sub

' Release the memory used
Public Sub Unload_A_COM()
On Error GoTo ErrHandler
    
  Call mo_Tools.Unload_A_ComControls(UserControl.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_Tools = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_Com")
End Sub

Private Sub SetTreeDelayedMode(ByVal ab_Delayed As Boolean)
On Error GoTo ErrHandler
    
  tvw_Main.Visible = Not ab_Delayed
  cmd_TVReLoad.Visible = ab_Delayed
  grd_Main.Visible = (Not ab_Delayed) And (Not tvw_Main.SelectedItem Is Nothing)
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetTreeDelayedMode")
End Sub

Private Sub LoadTreeView(ByVal ao_Tree As ArmTreeView, ByVal av_TreeviewInfo As Variant)
On Error GoTo ErrHandler

  Dim lv_NodeReq As Variant
  Dim lv_GridReq As Variant
  Dim lv_Images As Variant
  Dim lv_SelectedImages As Variant
  Dim ll_Levels As Long, ll_Idx As Long
  
  lv_NodeReq = av_TreeviewInfo(0)
  lv_GridReq = av_TreeviewInfo(1)
  lv_Images = av_TreeviewInfo(2)
  lv_SelectedImages = av_TreeviewInfo(3)
  
  ll_Levels = UBound(lv_NodeReq) + 1
  If ll_Levels > 0 Then
    ao_Tree.Levels = ll_Levels
    For ll_Idx = 0 To ll_Levels - 1
      lv_NodeReq(ll_Idx) = mo_Tools.ReplaceRequestByFrameData(lv_NodeReq(ll_Idx), UserControl.Controls, fra_MainFilter)
      lv_NodeReq(ll_Idx) = ReplaceCommonPlaceholders(lv_NodeReq(ll_Idx))
    Next
    ao_Tree.NodeRequests = lv_NodeReq
    ao_Tree.GridRequests = lv_GridReq
    ao_Tree.Images = lv_Images
    ao_Tree.SelectedImages = lv_SelectedImages
    If Not ao_Tree.LoadTree(LoadTypeChildsDemand) Then
      Err.Raise ArmErr.CompFncFailed, "ao_Tree.LoadTree(LoadTypeChildsDemand)", "Tree load failed: " & lv_NodeReq(0)
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadTreeView")
End Sub

Private Sub LoadGrid(ByVal ab_DelayedLoad As Boolean)
On Error GoTo ErrHandler

Dim lv_Requests As Variant

  If tvw_Main.SelectedItem Is Nothing Then
    grd_Main.Visible = False
  Else
    lv_Requests = ApplyTVFilters(tvw_Main.SelectedNodeRequest)
    
    If Not grd_Main.Load(lv_Requests, False, , , ab_DelayedLoad) Then
      Err.Raise ArmErr.CompFncFailed, "grd_Main.Load", "Method Load failed: " & lv_Requests(0)
    End If
    grd_Main.Visible = True
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadGrid")
End Sub

Private Sub btn_ExportCADPDF_Click()
On Error GoTo ErrHandler

Dim ls_PRD_Id As String, ls_OFD_Id As String, ls_PRD_Code As String
Dim ll_Idx As Long
Dim lo_XmlExport As New DPC_Interface
Dim ls_ErrMsg As String
Dim lb_Result As Boolean
Dim lo_Collection As New Collection
Dim ls_InstallDir As String

    If Not mo_Tools.HasSecurityAlias(ms_LoginName, "DPC_CAD_PDF_GENERATOR") Then
      Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9868, "#You do not have enough rights to do this operation")
      Exit Sub
    End If

  Call mo_Tools.LockScreen(Me, True)
  lb_Result = False
  
  'check version and update generator if new version is available
  ls_InstallDir = App.Path + "\" & INI_NETAPP_PATH & "\" & INI_DPC_CAD_PDF_GENERATOR_DIR
  If mo_Tools.CheckForNewVersion(SCREEN_NAME, "DPC_CAD_PDF_GEN", INI_DPC_CAD_PDF_GENERATOR_SETUP_EXE, ls_InstallDir, INI_DPC_CAD_PDF_GENERATOR_EXE, True) = False Then
    Exit Sub
  End If
  
  For ll_Idx = 0 To grd_Main.Rows - 1
    If StrComp(grd_Main.Data(ll_Idx, "Selected"), "CHECK") = 0 Then
      ls_PRD_Id = grd_Main.Data(ll_Idx, "PRD_Id")
      ls_PRD_Code = grd_Main.Data(ll_Idx, "PRD_Code")
      ls_OFD_Id = ""
      Call lo_Collection.Add(ls_PRD_Id & "," & ls_OFD_Id & "," & ls_PRD_Code)
    End If
  Next
  
  Set lo_XmlExport.ArmDb = mo_Db
  Set lo_XmlExport.Tools = mo_Tools
  lo_XmlExport.Language_Code = ms_Language_Code
  lo_XmlExport.CT_Code = "AT"
  lo_XmlExport.U_Code = ml_U_Code
  Call lo_XmlExport.Load_A_COM
  lb_Result = lo_XmlExport.CAD_GeneratePDFFiles("", lo_Collection, ls_ErrMsg)
  Call lo_XmlExport.Unload_A_COM
  Set lo_XmlExport = Nothing
  
  Call mo_Tools.LockScreen(Me, False)
  
  If lb_Result Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9862, "#Export CAD/PDF was successful. $TEXT$", Array("$OPERATION$", btn_ExportCADPDF.Caption, "$TEXT$", ""))
  Else
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9863, "#Export CAD/PDF failed: $ERROR$", Array("$OPERATION$", btn_ExportCADPDF.Caption, "$ERROR$", ls_ErrMsg))
  End If
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_ExportCADPDF_Click")
End Sub

Private Sub btn_PosListCalcBOMBOR_Click()
On Error GoTo ErrHandler

Dim ls_PRD_Id As String
Dim lo_DPC_Generate As New DPC_Generate
Dim lo_DPC_Product As DPC_Product
Dim ll_Idx As Long
Dim lo_PrdCollection As New Collection
Dim lo_ErrCollection As New Collection
Dim lb_inTransaction As Boolean
Dim ld_GenerateTime As Date, ld_StoreTime As Date


  If (grd_Main.Rows = 0) Or (grd_Main.Visible = False) Then
    Exit Sub
  End If
  
  If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Are you sure to '$OPERATION$' ($COUNT$)?", Array("$OPERATION$", btn_PosListCalcBOMBOR.Caption, "$COUNT$", grd_Main.Rows), vbYesNo) = vbNo Then
    Exit Sub
  End If
  
  ld_GenerateTime = Now
  lb_inTransaction = False
  Call mo_Tools.LockScreen(Me, True)
  
  lo_DPC_Generate.CURR_Code = "EUR"
  lo_DPC_Generate.Language_Code = ms_Language_Code
  lo_DPC_Generate.U_Code = ml_U_Code
  Set lo_DPC_Generate.ArmDb = mo_Db
  Set lo_DPC_Generate.Tools = mo_Tools
  Call lo_DPC_Generate.Load_A_COM
  
  For ll_Idx = 0 To grd_Main.Rows - 1
    ls_PRD_Id = grd_Main.Data(ll_Idx, "PRD_Id")
    Set lo_DPC_Product = New DPC_Product
    Set lo_DPC_Product.Tools = mo_Tools
    Set lo_DPC_Product.ArmDb = mo_Db
    lo_DPC_Product.U_Code = ml_U_Code
    lo_DPC_Product.CURR_Code = "EUR"
    lo_DPC_Product.Language_Code = ms_Language_Code
    lo_DPC_Product.IsProduction = True
    lo_DPC_Product.IsTemplate = True
    Call lo_DPC_Product.Load_A_COM
    Call lo_DPC_Product.InitOffer
    Call lo_DPC_Product.Load(ls_PRD_Id)
    Call lo_DPC_Product.LoadBOM
    Call lo_DPC_Product.LoadBOR
    lo_DPC_Product.PanelQtyM2 = Val(Replace(mo_Tools.GetAConfigData("DPC_STD_BOMBOR_M2"), ",", "."))
    Call lo_PrdCollection.Add(lo_DPC_Product)
  Next

  If lo_DPC_Generate.GenerateBOMandBOR(lo_PrdCollection, lo_ErrCollection) Then
    ld_GenerateTime = Now - ld_GenerateTime
    If ConfirmCheckList(lo_ErrCollection) Then
      ld_StoreTime = Now
      For ll_Idx = lo_PrdCollection.Count To 1 Step -1
        Set lo_DPC_Product = lo_PrdCollection(ll_Idx)
        
        Call mo_Tools.BeginBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "SaveBOMBOR")
        lb_inTransaction = True
        Call lo_DPC_Product.Update
        Call mo_Tools.CommitBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "SaveBOMBOR")
        lb_inTransaction = False
      Next
      ld_StoreTime = Now - ld_StoreTime
      Call MsgBox("BOM/BOR saved successfuly. Generate time: " & Format(ld_GenerateTime, "hh:mm:ss") & " Store time: " & Format(ld_StoreTime, "hh:mm:ss"))
    End If
  End If
  
  Call lo_DPC_Generate.Unload_A_COM
  Set lo_DPC_Generate = Nothing
  
  For ll_Idx = lo_PrdCollection.Count To 1 Step -1
    Set lo_DPC_Product = lo_PrdCollection(ll_Idx)
    Call lo_DPC_Product.Unload_A_COM
    Call lo_PrdCollection.Remove(ll_Idx)
    Set lo_DPC_Product = Nothing
  Next
  Set lo_PrdCollection = Nothing
  Call LoadGrid(False)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  If lb_inTransaction Then
    Call mo_Tools.RollbackBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "SaveBOMBOR")
  End If
  Call ErrorMessage("btn_PosListCalcBOMBOR_Click")
End Sub

Private Sub btn_PosListClearBOMBOR_Click()
On Error GoTo ErrHandler

Dim lo_DPC_Product As DPC_Product
Dim ls_PRD_Id As String
Dim lo_Collection As New Collection
Dim ll_Idx As Long
Dim lb_inTransaction As Boolean

  If (grd_Main.Rows = 0) Or (grd_Main.Visible = False) Then
    Exit Sub
  End If
  
  If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Are you sure to '$OPERATION$' ($COUNT$)?", Array("$OPERATION$", btn_PosListClearBOMBOR.Caption, "$COUNT$", grd_Main.Rows), vbYesNo) = vbNo Then
    Exit Sub
  End If
  
  Call mo_Tools.LockScreen(Me, True)
  lb_inTransaction = False
  For ll_Idx = 0 To grd_Main.Rows - 1
    ls_PRD_Id = grd_Main.Data(ll_Idx, "PRD_Id")
    
    Set lo_DPC_Product = New DPC_Product
    Set lo_DPC_Product.Tools = mo_Tools
    Set lo_DPC_Product.ArmDb = mo_Db
    lo_DPC_Product.U_Code = ml_U_Code
    'lo_DPC_Product.CT_Code = CT_Code
    lo_DPC_Product.CURR_Code = "EUR"
    'lo_DPC_Product.ValidityDate = ValidityDate
    lo_DPC_Product.Language_Code = ms_Language_Code
    'lo_DPC_Product.COF_Id = m_CurrentKey1
    lo_DPC_Product.IsProduction = True
    lo_DPC_Product.IsTemplate = True
    Call lo_DPC_Product.Load_A_COM
    'Call lo_DPC_Product.InitOffer
    Call lo_DPC_Product.Load(ls_PRD_Id)
    Call lo_Collection.Add(lo_DPC_Product)
  Next
  
  Call mo_Tools.BeginBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "DeleteBOMBOR")
  lb_inTransaction = True
  'Call RecordUpdateLastUser
  For Each lo_DPC_Product In lo_Collection
    Call lo_DPC_Product.DeleteBOMBOR
    ' update status BOM/BOR
  Next
  Call mo_Tools.CommitBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "DeleteBOMBOR")
  lb_inTransaction = False
  
  For ll_Idx = lo_Collection.Count To 1 Step -1
    Set lo_DPC_Product = lo_Collection(ll_Idx)
    Call lo_DPC_Product.Unload_A_COM
    Call lo_Collection.Remove(ll_Idx)
    Set lo_DPC_Product = Nothing
  Next
  Set lo_Collection = Nothing
  'Call tbs_Header_Click
  Call LoadGrid(False)
  Call mo_Tools.LockScreen(Me, False)
  Call MsgBox("Clear BOM/BOR successful")
  Exit Sub
ErrHandler:
  If lb_inTransaction Then
    Call mo_Tools.RollbackBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "DeleteBOMBOR")
  End If
  Call ErrorMessage("btn_PosListClearBOMBOR_Click")
End Sub

Private Sub btn_PosListEdit_Click()
On Error GoTo ErrHandler

  If grd_Main.SelectedCount <> 1 Then Exit Sub
  
  Call mo_Tools.LockScreen(Me, True)
  
  If ItemConfigSpc(eDPCScreenMode.smUpdate, grd_Main.SelectedLine(0, "PRD_Id")) Then
    Call LoadGrid(False)
  End If
  
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_PosListEdit_Click")
End Sub

Private Sub btn_XmlPMaster_Click()
On Error GoTo ErrHandler

Dim lo_XmlExport As New DPC_Interface
Dim ll_Idx As Long
Dim ls_req As String
Dim ls_ErrMessage As String
Dim lb_Result As Boolean
Dim lo_Collection As New Collection
Dim ls_PRD_Id As String
Dim ld_ExportTime As Date

  If (grd_Main.Rows = 0) Or (grd_Main.Visible = False) Then
    Exit Sub
  End If
  
  If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Are you sure to '$OPERATION$' ($COUNT$)?", Array("$OPERATION$", btn_XmlPMaster.Caption, "$COUNT$", grd_Main.Rows), vbYesNo) = vbNo Then
    Exit Sub
  End If
  
  ld_ExportTime = Now
  Call mo_Tools.LockScreen(Me, True)
  
  ls_ErrMessage = ""
  For ll_Idx = 0 To grd_Main.Rows - 1
    ls_PRD_Id = grd_Main.Data(ll_Idx, "PRD_Id")
    Call lo_Collection.Add(ls_PRD_Id)
  Next
  
  Set lo_XmlExport.ArmDb = mo_Db
  Set lo_XmlExport.Tools = mo_Tools
  lo_XmlExport.U_Code = ml_U_Code
  Call lo_XmlExport.Load_A_COM
  lb_Result = lo_XmlExport.Bae_ExportArticleCollection(lo_Collection, ls_ErrMessage)
  Call lo_XmlExport.Unload_A_COM
  
  Call mo_Tools.LockScreen(Me, False)
  
  ld_ExportTime = Now - ld_ExportTime
  If lb_Result Then
    Call MsgBox("Export PMaster to B7 succeeded for articles count: " & lo_Collection.Count & " Export time: " & Format(ld_ExportTime, "hh:mm:ss"))
  Else
    Call MsgBox("Export PMaster to B7 failed: " & ls_ErrMessage)
  End If
  Call mo_Tools.ClearCollection(lo_Collection)
  Set lo_Collection = Nothing
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_XmlPMaster_Click")
End Sub

Private Sub cal11_changeposition(y As Integer)
On Error GoTo ErrHandler
  
  Call cal11.Zorder
  cal11.Top = cal11.Top + y
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal11_changeposition")
End Sub

Private Sub cal12_changeposition(y As Integer)
On Error GoTo ErrHandler
  
  Call cal12.Zorder
  cal12.Top = cal12.Top + y
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal12_changeposition")
End Sub

Private Sub cal11_datechangee()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)
  Call SetTreeDelayedMode(True)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal11_datechangee")
End Sub

Private Sub cal12_datechangee()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)
  Call SetTreeDelayedMode(True)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal12_datechangee")
End Sub

Private Sub cbo_View_ComboItemSelected()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)
  
  If Not cbo_View.SelectedItem Is Nothing Then
    mv_TreeviewInfo = mo_Tools.LoadTreeViewInfo(mo_Db, SCREEN_NAME, cbo_View.SelectedItem.Key)
    Call LoadTreeView(tvw_Main, mv_TreeviewInfo)
    Call SetTreeDelayedMode(False)
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_Views_ComboItemSelected")
End Sub

Private Sub cmd_RecalcCost_Click()
On Error GoTo ErrHandler

Dim lo_DPC_Product As New DPC_Product
Dim lo_XmlExport As New DPC_Interface
Dim ls_PRD_Id As String
Dim ll_Idx As Long
Dim ls_req As String
Dim ls_ErrMessage As String
Dim lb_ExportOK As Boolean
Dim ll_Count As Long
Dim lb_inTransaction As Boolean

  If (grd_Main.Rows = 0) Or (grd_Main.Visible = False) Then
    Exit Sub
  End If
  
  If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Are you sure to '$OPERATION$' ($COUNT$)?", Array("$OPERATION$", cmd_RecalcCost.Caption, "$COUNT$", grd_Main.Rows), vbYesNo) = vbNo Then
    Exit Sub
  End If
  
  Call mo_Tools.LockScreen(Me, True)
  lb_ExportOK = True
  ls_ErrMessage = ""
  ll_Count = 0
  For ll_Idx = 0 To grd_Main.Rows - 1
    ls_PRD_Id = grd_Main.Data(ll_Idx, "PRD_Id")
    
    Set lo_DPC_Product.Tools = mo_Tools
    Set lo_DPC_Product.ArmDb = mo_Db
    lo_DPC_Product.U_Code = ml_U_Code
    lo_DPC_Product.CURR_Code = "EUR"
    lo_DPC_Product.Language_Code = ms_Language_Code
    lo_DPC_Product.IsProduction = True
    lo_DPC_Product.IsTemplate = True
    Call lo_DPC_Product.Load_A_COM
    Call lo_DPC_Product.Load(ls_PRD_Id)
    Call lo_DPC_Product.LoadBOM
    Call lo_DPC_Product.LoadBOR
    If lo_DPC_Product.HasBOMError Or (Not lo_DPC_Product.HasBOM) Or lo_DPC_Product.HasBORError Or (Not lo_DPC_Product.HasBOR) Then
      Call MsgBox("You cannot recalculate article " & lo_DPC_Product.PRD_Code & " which has empty or error BOM/BOR")
      lb_ExportOK = False
      ls_ErrMessage = ls_ErrMessage & " " & lo_DPC_Product.PRD_Code
    Else
      Call lo_DPC_Product.InitCostParameters
      Call lo_DPC_Product.InitCostCalc
      Call lo_DPC_Product.CalculateCost
      
      Call mo_Tools.BeginBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "CalculateCost")
      lb_inTransaction = True
      Call lo_DPC_Product.Update
      Call mo_Tools.CommitBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "CalculateCost")
      lb_inTransaction = False
      ll_Count = ll_Count + 1
    End If
    
    Call lo_DPC_Product.Unload_A_COM
  Next
  Call mo_Tools.LockScreen(Me, False)
  If lb_ExportOK Then
    Call MsgBox("Recalculate succeeded for " & ll_Count & " articles")
  Else
    Call MsgBox("Recalculate failed for products: " & ls_ErrMessage)
  End If
  Exit Sub
ErrHandler:
  If lb_inTransaction Then
    Call mo_Tools.RollbackBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "CalculateCost")
  End If
  Call ErrorMessage("cmd_RecalcCost_Click")
End Sub

Private Sub btn_ShowPDF_Click()
On Error GoTo ErrHandler

Dim lo_shell As Object
Dim ls_PDFName As String
Dim ls_ErrorMsg As String
Dim ll_Idx As Long

  For ll_Idx = 0 To grd_Main.Rows - 1
    If StrComp(grd_Main.Data(ll_Idx, "Selected"), "CHECK", vbTextCompare) = 0 Then
      ls_PDFName = grd_Main.Data(ll_Idx, "PRD_Code")
      ls_PDFName = mo_Tools.GetAConfigData("DPC_CAD_DestDir") + "\" + ls_PDFName + ".pdf"
          
      If Not mo_FSO.FileExists(ls_PDFName) Then
          ls_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_PDFName))
          Call MsgBox(ls_ErrorMsg, vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
          Exit Sub
      End If
      Set lo_shell = CreateObject("Shell.Application")
      Call lo_shell.ShellExecute(ls_PDFName, "", "", "open", 1)
      Set lo_shell = Nothing
    End If
  Next
  Exit Sub
ErrHandler:
  Set lo_shell = Nothing
  Call ErrorMessage("btn_ShowPDF_Click")
End Sub

Private Sub grd_Main_ItemSelected()
On Error GoTo ErrHandler

  Call mo_Tools.LockScreen(Me, True)
  If grd_Main.SelectedCount = 1 Then
    Call ItemUpdate(grd_Main.SelectedLine(0, "PRD_Id"))
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("grd_Main_ItemSelected")
End Sub

Private Sub ItemAdd(ByVal ae_CAT_Id As eDPCCategory, ByVal al_SYS_Id As Long)
On Error GoTo ErrHandler
Dim lo_DPC_Config As frmDPC_Config

  Set lo_DPC_Config = New frmDPC_Config
  Load lo_DPC_Config
  Set lo_DPC_Config.Tools = mo_Tools
  Set lo_DPC_Config.ArmDb = mo_Db
  lo_DPC_Config.U_Code = ml_U_Code
  lo_DPC_Config.Language_Code = ms_Language_Code
  lo_DPC_Config.COF_Lang = ms_Language_Code
  'lo_DPC_Config.CURR_Code = ""
  lo_DPC_Config.CT_Code = ""
  lo_DPC_Config.IsProduction = True
  lo_DPC_Config.IsTemplate = True
  Call lo_DPC_Config.Load_A_COM
  Call lo_DPC_Config.ItemNew(ae_CAT_Id, al_SYS_Id)
  
  Call mo_Tools.LockScreen(Me, False)
  Call mo_Tools.ShowModalForm(lo_DPC_Config)
  Call mo_Tools.LockScreen(Me, True)
  
  If lo_DPC_Config.Result Then
    Call lo_DPC_Config.ItemSave
  End If
  Call lo_DPC_Config.Unload_A_COM
  Unload lo_DPC_Config
  Set lo_DPC_Config = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("ItemAdd")
End Sub

Private Sub ItemUpdate(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler
Dim lo_DPC_Config As frmDPC_Config

  Set lo_DPC_Config = New frmDPC_Config
  Load lo_DPC_Config
  Set lo_DPC_Config.Tools = mo_Tools
  Set lo_DPC_Config.ArmDb = mo_Db
  lo_DPC_Config.U_Code = ml_U_Code
  lo_DPC_Config.Language_Code = ms_Language_Code
  lo_DPC_Config.COF_Lang = ms_Language_Code
  'lo_DPC_Config.CURR_Code = ""
  lo_DPC_Config.CT_Code = ""
  lo_DPC_Config.IsProduction = True
  lo_DPC_Config.IsTemplate = True
  Call lo_DPC_Config.Load_A_COM
  Call lo_DPC_Config.ItemUpdate(as_PRD_Id)
  
  Call mo_Tools.LockScreen(Me, False)
  Call mo_Tools.ShowModalForm(lo_DPC_Config)
  Call mo_Tools.LockScreen(Me, True)
  
  If lo_DPC_Config.Result Then
    Call lo_DPC_Config.ItemSave
  End If
  Call lo_DPC_Config.Unload_A_COM
  Unload lo_DPC_Config
  Set lo_DPC_Config = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("ItemUpdate")
End Sub

Private Sub ItemDelete(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler
Dim lo_Product As DPC_Product

  Set lo_Product = New DPC_Product
  Set lo_Product.Tools = mo_Tools
  Set lo_Product.ArmDb = mo_Db
  lo_Product.U_Code = ml_U_Code
  'lo_Product.CT_Code = CT_Code
  'lo_Product.CURR_Code = CURR_Code
  'lo_Product.ValidityDate = ValidityDate
  lo_Product.Language_Code = ms_Language_Code
  lo_Product.IsTemplate = True

  Call lo_Product.Load_A_COM
  Call lo_Product.Load(as_PRD_Id)
  Call lo_Product.Drop
  Call lo_Product.Unload_A_COM
  Set lo_Product = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("ItemDelete")
End Sub

Private Function ItemConfigSpc(ByVal ae_Mode As eDPCScreenMode, ByVal as_PRD_Id As String) As Boolean
On Error GoTo ErrHandler

Dim lo_DPC_ConfigSpc As frmDPC_ConfigSpc
Dim lo_Collection As Collection
Dim lb_InTran As Boolean

  ItemConfigSpc = False
  Set lo_DPC_ConfigSpc = New frmDPC_ConfigSpc
  Load lo_DPC_ConfigSpc
  Set lo_DPC_ConfigSpc.Tools = mo_Tools
  Set lo_DPC_ConfigSpc.ArmDb = mo_Db
  lo_DPC_ConfigSpc.Language_Code = ms_Language_Code
  lo_DPC_ConfigSpc.U_Code = ml_U_Code
  lo_DPC_ConfigSpc.COF_Lang = ms_Language_Code
  lo_DPC_ConfigSpc.CURR_Code = "EUR"
  'lo_DPC_ConfigSpc.CT_Code = CT_Code
  'lo_DPC_ConfigSpc.ValidityDate = ValidityDate
  'lo_DPC_ConfigSpc.COF_Id = m_CurrentKey1
  'lo_DPC_ConfigSpc.LEN_Id = mo_Tools.GetComboKey(cbo_LegalEntity)
  'lo_DPC_ConfigSpc.CanChangeManualPrice = mb_HasLevel2
  'lo_DPC_ConfigSpc.OFD_Pos = ao_OfferPos.OFD_Pos
  'lo_DPC_ConfigSpc.OFD_WshDat = ao_OfferPos.OFD_WshDat
  'lo_DPC_ConfigSpc.OFD_ShpDat = ao_OfferPos.OFD_ShpDat
  'lo_DPC_ConfigSpc.OFD_DelDat = ao_OfferPos.OFD_DelDat
  lo_DPC_ConfigSpc.IsProduction = True
  lo_DPC_ConfigSpc.IsTemplate = True
  Call lo_DPC_ConfigSpc.Load_A_COM
  If ae_Mode = eDPCScreenMode.smAdd Then
    Call lo_DPC_ConfigSpc.ItemAdd(as_PRD_Id)
  ElseIf ae_Mode = eDPCScreenMode.smUpdate Then
    Call lo_DPC_ConfigSpc.ItemUpdate(as_PRD_Id)
    'Call lo_DPC_ConfigSpc.LoadOffer(m_CurrentKey1, ao_OfferPos.OFD_IdPar)
  End If
  
  Call mo_Tools.LockScreen(Me, False)
  Call mo_Tools.ShowModalForm(lo_DPC_ConfigSpc)
  Call mo_Tools.LockScreen(Me, True)
  
  If lo_DPC_ConfigSpc.Result Then
    Call mo_Tools.BeginBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "ItemConfigSpc")
    lb_InTran = True
    'Call RecordUpdateLastUser
    Call lo_DPC_ConfigSpc.ItemSave
    'Set lo_Collection = lo_DPC_ConfigSpc.GenerateOfferDetail
    'Call SaveOfferDetail(lo_Collection, ao_OfferPos.OFD_IdPar, md_COF_DocDat, CURR_Code)
    Call mo_Tools.CommitBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "ItemConfigSpc")
    lb_InTran = False
    ItemConfigSpc = True
  End If
  
  Call lo_DPC_ConfigSpc.Unload_A_COM
  Unload lo_DPC_ConfigSpc
  Set lo_DPC_ConfigSpc = Nothing
  Exit Function
ErrHandler:
  If lb_InTran Then
    Call mo_Tools.RollbackBatchTran(mo_Db, ml_U_Code, SCREEN_NAME, "ItemConfigSpc")
  End If
  Call ErrorHandler("ItemConfigSpc")
End Function

Private Sub grd_Main_MouseDown(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal al_Row As Long, ByVal al_Col As Long)
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  mb_InternalInit = True
  
  If al_Row >= 0 And al_Col = grd_Main.Columns("Selected").ColumnIndex Then
    If StrComp(grd_Main.Data(al_Row, "Selected"), "UNCHECK", vbTextCompare) = 0 Then
      grd_Main.Data(al_Row, "Selected") = "CHECK"
    Else
      grd_Main.Data(al_Row, "Selected") = "UNCHECK"
    End If
  End If
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorMessage("grd_PosList_MouseDown")
End Sub

Private Sub opt_Category_Click(Index As Integer)
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)

  Call SetTreeDelayedMode(True)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("opt_Category_Click")
End Sub

Private Sub opt_date_Click(Index As Integer)
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)
  If Index = 0 Then
    cal11.Visible = False
    cal12.Visible = False
    Call cal11.reinit_cal
    Call cal12.reinit_cal
    cbo_date.Visible = False
  Else
    cal11.Visible = True
    cal12.Visible = True
    cbo_date.Visible = True
            
    If cbo_date.SelectedItem Is Nothing Then
      cbo_date.FirstBlankItem = False
      cbo_date.Request = "exec captv_date_cbo 'TV_Cap_OfferProd_date','" & ms_Language_Code & "'"
      Call cbo_date.Load
      Call cbo_date.SearchItem("1", 2, 0)
    End If
  End If
  Call SetTreeDelayedMode(True)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("opt_date_Click")
End Sub

Private Sub txt_Textbox_KeyPress(Index As Integer, KeyAscii As Integer)
On Error GoTo ErrHandler
  
  If mb_InternalInit Then Exit Sub
  If KeyAscii = 13 Then
    Call tlb_Main_action("F", ms_Language_Code)
  End If
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_Textbox_KeyPress")
End Sub

Private Sub ExportExcelOfferTemp()
Dim lo_ExcelProcessor As CExcelTemplateProcessor
Dim ls_req As String
Dim ls_ErrorMsg As String
Dim ls_TemplateFile As String

  If Not mo_Tools.HasSecurityAlias(ms_LoginName, "DPC_TEMPEXPORTEXCEL") Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9868, "#You do not have enough rights to do this operation")
    Exit Sub
  End If
  
  If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9864, "#Are you sure to '$OPERATION$' ?", Array("$OPERATION$", "Export Excel"), vbYesNo) = vbNo Then
    Exit Sub
  End If

  ls_TemplateFile = "DPC_OfferExportTemp.xlsx"
  
  'following function will change ls_TemplateFile - it adds version in the name and creates full path!
  If mo_Tools.LoadLatestAFile("EXCEL_TMP_OTEMP", App.Path & "\Download\ExcelTmp\", ls_TemplateFile) = False Then
      Exit Sub
  End If
  
  Set lo_ExcelProcessor = New CExcelTemplateProcessor
  Set lo_ExcelProcessor.ArmDb = mo_Db
  lo_ExcelProcessor.Language = ms_Language_Code
  lo_ExcelProcessor.ScreenName = "Cap_OfferTempExcel"
  Set lo_ExcelProcessor.Tools = mo_Tools
  Call lo_ExcelProcessor.Load_A_COM
  
  ls_req = grd_Main.Requests(0)
  ls_req = Replace(ls_req, "Cap_OfferTemp_grd", "Cap_OfferTemp_excel")
  
  'Call lo_ExcelProcessor.AddNewOfferData(ls_Req)
  
  Call lo_ExcelProcessor.AddNewOfferTempTable(ls_req)
    
  If Not lo_ExcelProcessor.ProcessOfferTempFile(ls_TemplateFile, ls_ErrorMsg) Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9863, "#Export to Excel failed: $ERROR$", Array("$OPERATION$", "Export Excel", "$ERROR$", ls_ErrorMsg))
  End If
  Call lo_ExcelProcessor.Unload_A_COM
  Set lo_ExcelProcessor = Nothing
  Exit Sub
ErrHandler:
  Call ErrorMessage("ExportExcelOfferTemp")
End Sub

Private Function ConfirmCheckList(ByVal ao_ErrCol As Collection) As Boolean
On Error GoTo ErrHandler

Dim lo_ErrorMsg As frmDPC_ErrorMsg
  
  ConfirmCheckList = True
  If ao_ErrCol.Count > 0 Then
    Set lo_ErrorMsg = New frmDPC_ErrorMsg
    Load lo_ErrorMsg
    Set lo_ErrorMsg.Tools = mo_Tools
    Set lo_ErrorMsg.ArmDb = mo_Db
    lo_ErrorMsg.Language_Code = ms_Language_Code
    lo_ErrorMsg.U_Code = ml_U_Code
    Set lo_ErrorMsg.ErrCollection = ao_ErrCol
    Call lo_ErrorMsg.Load_A_COM
    
    Call mo_Tools.LockScreen(Me, False)
    Call mo_Tools.ShowModalForm(lo_ErrorMsg)
    Call mo_Tools.LockScreen(Me, True)
    
    If lo_ErrorMsg.Result = False Then
      ConfirmCheckList = False
    End If
    Call lo_ErrorMsg.Unload_A_COM
    Unload lo_ErrorMsg
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("ConfirmCheckList")
End Function

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  Call mo_Tools.LockScreen(Me, True)
  Select Case as_Role
  Case "A"  'Add
    If tvw_Main.SelectedItem Is Nothing Then
      Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9734, "#Please, select system in treeview")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    If tvw_Main.SelectedItem.Tag.ml_Level <> 1 Then
      Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9734, "#Please, select system in treeview")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    Call ItemAdd(CAT_Id, tvw_Main.SelectedItem.Tag.IDValue)
    Call LoadGrid(False)
  Case "B"  'update
    If grd_Main.SelectedCount = 1 Then
      Call ItemUpdate(grd_Main.SelectedLine(0, "PRD_Id"))
      Call LoadGrid(False)
    Else
      Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9723, "#Please, select one row")
    End If
  Case "C"  'delete
    If grd_Main.SelectedCount = 1 Then
      If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9735, "#Are you sure to delete this item ?", , vbYesNo) = vbYes Then
        Call ItemDelete(grd_Main.SelectedLine(0, "PRD_Id"))
        Call LoadGrid(False)
      End If
    Else
      Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9723, "#Please, select one row")
    End If
  Case "F"  'refresh
    Call tvw_Main.Refresh
    Call LoadGrid(False)
  Case "G"
    If grd_Main.Rows > 0 Then
        Call ExportExcelOfferTemp
    End If
  Case "T"
    Call mo_Tools.LockScreen(Me, False)
    RaiseEvent quit
    Exit Sub
  Case Else
    Err.Raise ArmErr.InvalidArgument, "as_Role", "Unknown role: " & as_Role
  End Select
  
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("tlb_Main_action")
End Sub

Private Sub cmd_TVReLoad_Click()
On Error GoTo ErrHandler
    
  If mb_InternalInit Then Exit Sub
  
  Call mo_Tools.LockScreen(Me, True)
  Call LoadTreeView(tvw_Main, mv_TreeviewInfo)
  Call SetTreeDelayedMode(False)
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("cmd_TVReLoad_Click")
End Sub

Private Sub tvw_Main_NodeClick(ByVal Node As MSComctlLib.Node)
On Error GoTo ErrHandler

Dim lv_Requests As Variant
Dim lb_DelayedLoad As Boolean

  If mb_InternalInit Then Exit Sub
  If Node Is Nothing Then Exit Sub
  
  Call mo_Tools.LockScreen(Me, True)
  
  lb_DelayedLoad = (tvw_Main.NodeInfo(Node).ml_Level < tvw_Main.Levels - 1)
  Call LoadGrid(lb_DelayedLoad)
  
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("tvw_Main_NodeClick")
End Sub

Private Function ApplyTVFilters(ByVal av_Request As Variant) As Variant
On Error GoTo ErrHandler
    Dim lv_Requests As Variant
    
    If IsArray(av_Request) Then
      ReDim lv_Requests(UBound(av_Request))
      Dim ll_Idx As Long, ll_Count As Long
      ll_Count = UBound(lv_Requests)
      For ll_Idx = 0 To ll_Count
        lv_Requests(ll_Idx) = av_Request(ll_Idx)
        lv_Requests(ll_Idx) = ReplaceCustomPlaceholders(lv_Requests(ll_Idx))
        lv_Requests(ll_Idx) = mo_Tools.ReplaceRequestByFrameData(lv_Requests(ll_Idx), UserControl.Controls, fra_MainFilter)
        lv_Requests(ll_Idx) = mo_Tools.ReplaceRequestByFrameData(lv_Requests(ll_Idx), UserControl.Controls, fra_GridFilter)
        lv_Requests(ll_Idx) = mo_Tools.ReplacePlaceholderByControlValue(lv_Requests(ll_Idx), tvw_Main)
        lv_Requests(ll_Idx) = mo_Tools.ReplaceLanguagePlaceholderFromToolbar(lv_Requests(ll_Idx), tlb_Main)
        lv_Requests(ll_Idx) = ReplaceCommonPlaceholders(lv_Requests(ll_Idx))
      Next
    Else
      ReDim lv_Requests(0)
      lv_Requests(0) = av_Request
      lv_Requests(0) = ReplaceCustomPlaceholders(lv_Requests(0))
      lv_Requests(0) = mo_Tools.ReplaceRequestByFrameData(lv_Requests(0), UserControl.Controls, fra_GridFilter)
      lv_Requests(0) = mo_Tools.ReplaceRequestByFrameData(lv_Requests(0), UserControl.Controls, fra_MainFilter)
      lv_Requests(0) = mo_Tools.ReplacePlaceholderByControlValue(lv_Requests(0), tvw_Main)
      lv_Requests(0) = mo_Tools.ReplaceLanguagePlaceholderFromToolbar(lv_Requests(0), tlb_Main)
      lv_Requests(0) = ReplaceCommonPlaceholders(lv_Requests(0))
    End If

    ApplyTVFilters = lv_Requests
    Exit Function
ErrHandler:
    Call ErrorHandler("ApplyTVFilters")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

Dim ll_Left As Long

  If (Width <= 2 * fra_MainFilter.Width) Or (Height <= 2 * fra_MainFilter.Height) Then Exit Sub
  
  Call fra_MainItem.Move(0, 0, Width, Height)
  Call fra_MainFilter.Move(FRM_SPACE_HOR, FRM_SPACE_VER)
  Call tlb_Main.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR, 2 * FRM_SPACE_VER, fra_MainItem.Width - (fra_MainFilter.Left + fra_MainFilter.Width + 2 * FRM_SPACE_HOR))
  Call fra_GridFilter.Move(tlb_Main.Left, tlb_Main.Top + tlb_Main.Height + FRM_SPACE_VER, tlb_Main.Width)
  
  Call grd_Main.Move(tlb_Main.Left, fra_GridFilter.Top + fra_GridFilter.Height + FRM_SPACE_VER, tlb_Main.Width, fra_MainItem.Height - tlb_Main.Height - fra_GridFilter.Height - 4 * FRM_SPACE_VER)
  Call cbo_View.Move(FRM_SPACE_HOR, fra_MainFilter.Top + fra_MainFilter.Height + FRM_SPACE_VER, fra_MainFilter.Width)
  Call tvw_Main.Move(FRM_SPACE_HOR, cbo_View.Top + cbo_View.Height + FRM_SPACE_VER, fra_MainFilter.Width)
  
  If fra_MainItem.Height - tvw_Main.Top - FRM_SPACE_VER > 0 Then
    tvw_Main.Height = fra_MainItem.Height - tvw_Main.Top - FRM_SPACE_VER
  End If
  
  Call cmd_TVReLoad.Move(tvw_Main.Left, tvw_Main.Top)

  Exit Sub
ErrHandler:
  Call ErrorHandler("Resize")
End Sub

Private Function ReplaceCustomPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = Replace(as_Request, "$CAT_Id$", mo_Tools.SqlIntKey(CAT_Id), , , vbTextCompare)
    ReplaceCustomPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCustomPlaceholders")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$iConcurrency$", mo_Tools.SqlInt(ml_iConcurrency), , , vbTextCompare)
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
  Dim ls_ErrSource As String
  Dim ls_errDescription As String
  Dim ls_Message As String
  
  ls_ErrSource = as_Fct & SEP1 & Err.Source
  ls_errDescription = Err.Description
  ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
  Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
  Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
  End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
  Call Err.Raise(Err.Number, UserControl.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

